	function msd = genmsdcoeffs_int(val, level)
	%msd = genmsdcoeffs_int(val, level)
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	if val == 0
		msd = 0;
		return
	end
	
	if level == 0
		msd = [];
		return
	end
	
	scale = 0;
	while mod(val, 2) == 0
		val = val/2;
		scale = scale+1;
	end
	
	msd1 = genmsdcoeffs_int(val-1, level-1);
	msd2 = genmsdcoeffs_int(val+1, level-1);
	
	if size(msd1, 1) > 0
		msd1(:, end) = 1;
	end
	
	if size(msd2, 1) > 0
		msd2(:, end) = -1;
	end
	
	msd = zeros(size(msd1, 1)+size(msd2, 1), max(size(msd1, 2), size(msd2, 2))+scale);
	msd(1:size(msd1, 1), end-size(msd1, 2)+1-scale:end-scale) = msd1;
	msd(size(msd1, 1)+1:end, end-size(msd2, 2)+1-scale:end-scale) = msd2;
	
